
  import javafx.application.Application;
  import javafx.event.ActionEvent;
  import javafx.scene.Scene;
  import javafx.stage.Stage;
  import javafx.scene.control.*;
  import javafx.scene.layout.Pane;
  import javafx.scene.text.Font;
  import java.text.DecimalFormat;
  public class AddingMachineV3 extends Application 
  {
     Label description, plus, equals, sum, a, b;
     TextField aValue, bValue; 
     Button compute, clear;
     
     @Override
     public void start(Stage primaryStage) 
     {
        // Step 1, declare the component objects
        description = new Label("Computes a + b");
        aValue = new TextField();
        plus = new Label("+");
        bValue = new TextField();
        equals = new Label("=");
        sum = new Label("x,xxx.xx");
        a = new Label("a");
        b = new Label("b");
        compute = new Button(" Compute ");
        clear = new Button  ("  Clear   ");

        // Step 2, specify the components properties
        description.setLayoutX(120);
        description.setLayoutY(0);
        description.setPrefSize(300, 30);
        description.setFont(new Font("Arial", 24));
        aValue.setLayoutX(60);
        aValue.setLayoutY(50);
        aValue.setPrefSize(120, 30);
        aValue.setFont(new Font("Arial", 18));
        plus.setLayoutX(195);
        plus.setLayoutY(50);
        plus.setPrefSize(20, 30);
        plus.setFont(new Font("Arial", 24));
        equals.setLayoutX(365);
        equals.setLayoutY(50);
        equals.setPrefSize(20, 30);
        equals.setFont(new Font("Arial", 24));
        bValue.setLayoutX(230);
        bValue.setLayoutY(50);
        bValue.setPrefSize(120, 30);
        bValue.setFont(new Font("Arial", 18));
        sum.setLayoutX(395);
        sum.setLayoutY(50);
        sum.setPrefSize(120, 30);
        sum.setFont(new Font("Arial", 18));
        a.setLayoutX(105);
        a.setLayoutY(85);
        a.setPrefSize(20, 30);
        a.setPrefHeight(30);
        a.setFont(new Font("Arial", 24));
        b.setLayoutX(275);
        b.setLayoutY(85);
        b.setPrefSize(20, 30);
        b.setPrefHeight(30);
        b.setFont(new Font("Arial", 24));
        compute.setLayoutX(70);
        compute.setLayoutY(120);
        compute.setPrefSize(90, 25);
        compute.setOnAction(e -> computeClickHandler(e)); 
        clear.setLayoutX(242);
        clear.setLayoutY(120);
        clear.setPrefSize(90, 25);
        clear.setOnAction(e -> clearClickHandler(e)); 

        // Step 4, add the components to the window
        Pane pane = new Pane();
        pane.getChildren().addAll(description, aValue, plus, bValue, equals,
                                  sum, a, compute, clear);
        Scene scene = new Scene(pane, 500, 200);
        
        primaryStage.setTitle("Calculator");
        primaryStage.setScene(scene);
        primaryStage.show();
    }

    public void computeClickHandler(ActionEvent e)
    {
        String s;
        double a, b, result;
        DecimalFormat f = new DecimalFormat("#,##0.00");
        
        s = aValue.getText();
        a = Double.parseDouble(s);
        s = bValue.getText();
        b = Double.parseDouble(s);
        result = a + b;
        sum.setText(f.format(result));
     }        

     public void clearClickHandler(ActionEvent e)
     {
        aValue.setText("");
        bValue.setText("");
        sum.setText("x,xxx.xx");
     }
     public static void main(String[] args) 
     {
        launch(args);
     }
  }

